/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.nonliving;

import java.util.UUID;
import net.adventurez.init.EntityInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TinyEyeEntity
extends AbstractHurtingProjectile {
    private Entity target;
    @Nullable
    private Direction direction;
    private int stepCount;
    private double targetX;
    private double targetY;
    private double targetZ;
    @Nullable
    private UUID targetUuid;

    public TinyEyeEntity(EntityType<? extends TinyEyeEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Environment(value=EnvType.CLIENT)
    public TinyEyeEntity(Level world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this(EntityInit.TINY_EYE, world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20334_(velocityX, velocityY, velocityZ);
    }

    public TinyEyeEntity(Level world, LivingEntity owner, Entity target, Direction.Axis axis) {
        this(EntityInit.TINY_EYE, world);
        this.m_5602_((Entity)owner);
        BlockPos blockPos = owner.m_20183_();
        double d = (double)blockPos.m_123341_() + 0.5;
        double e = (double)blockPos.m_123342_() + 0.5;
        double f = (double)blockPos.m_123343_() + 0.5;
        this.m_7678_(d, e, f, this.m_146908_(), this.m_146909_());
        this.target = target;
        this.direction = Direction.UP;
        this.movingAround();
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.target != null) {
            tag.m_128362_("Target", this.target.m_20148_());
        }
        if (this.direction != null) {
            tag.m_128405_("Dir", this.direction.m_122411_());
        }
        tag.m_128405_("Steps", this.stepCount);
        tag.m_128347_("TXD", this.targetX);
        tag.m_128347_("TYD", this.targetY);
        tag.m_128347_("TZD", this.targetZ);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.stepCount = tag.m_128451_("Steps");
        this.targetX = tag.m_128459_("TXD");
        this.targetY = tag.m_128459_("TYD");
        this.targetZ = tag.m_128459_("TZD");
        if (tag.m_128425_("Dir", 99)) {
            this.direction = Direction.m_122376_((int)tag.m_128451_("Dir"));
        }
        if (tag.m_128403_("Target")) {
            this.targetUuid = tag.m_128342_("Target");
        }
    }

    protected void m_8097_() {
    }

    private void movingAround() {
        BlockPos blockPos;
        double d = 0.5;
        if (this.target == null) {
            blockPos = this.m_20183_().m_7495_();
        } else {
            d = (double)this.target.m_20206_() * 0.5;
            blockPos = BlockPos.m_274561_((double)this.target.m_20185_(), (double)(this.target.m_20186_() + d), (double)this.target.m_20189_());
        }
        double e = (double)blockPos.m_123341_() + 0.5;
        double f = (double)blockPos.m_123342_() + d;
        double g = (double)blockPos.m_123343_() + 0.5;
        double h = e - this.m_20185_();
        double j = f - this.m_20186_();
        double k = g - this.m_20189_();
        double l = Mth.m_14116_((float)((float)(h * h + j * j + k * k)));
        if (l == 0.0) {
            this.targetX = 0.0;
            this.targetY = 0.0;
            this.targetZ = 0.0;
        } else {
            this.targetX = h / l * 0.15;
            this.targetY = j / l * 0.15;
            this.targetZ = k / l * 0.15;
        }
        this.f_19812_ = true;
        this.stepCount = 10 + this.f_19796_.m_188503_(5) * 10;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        Vec3 vec3d;
        if (!this.m_9236_().m_5776_()) {
            HitResult hitResult;
            if (this.target == null && this.targetUuid != null) {
                this.target = ((ServerLevel)this.m_9236_()).m_8791_(this.targetUuid);
                if (this.target == null) {
                    this.targetUuid = null;
                }
            }
            if (this.target == null || !this.target.m_6084_() || this.target instanceof Player && ((Player)this.target).m_5833_()) {
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            } else {
                this.targetX = Mth.m_14008_((double)(this.targetX * 1.025), (double)-1.0, (double)1.0);
                this.targetY = Mth.m_14008_((double)(this.targetY * 1.025), (double)-1.0, (double)1.0);
                this.targetZ = Mth.m_14008_((double)(this.targetZ * 1.025), (double)-1.0, (double)1.0);
                vec3d = this.m_20184_();
                this.m_20256_(vec3d.m_82520_((this.targetX - vec3d.f_82479_) * 0.2, (this.targetY - vec3d.f_82480_) * 0.2, (this.targetZ - vec3d.f_82481_) * 0.2));
            }
            if ((hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS) {
                this.m_6532_(hitResult);
            }
        }
        this.m_20101_();
        vec3d = this.m_20184_();
        this.m_20248_(this.m_20185_() + vec3d.f_82479_, this.m_20186_() + vec3d.f_82480_, this.m_20189_() + vec3d.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
        if (!this.m_9236_().m_5776_() && this.target != null && !this.target.m_213877_()) {
            if (this.stepCount > 0) {
                --this.stepCount;
                if (this.stepCount == 0) {
                    this.movingAround();
                }
            }
            if (this.direction != null) {
                BlockPos blockPos = this.m_20183_();
                Direction.Axis axis = this.direction.m_122434_();
                if (this.m_9236_().m_46575_(blockPos.m_121945_(this.direction), (Entity)this)) {
                    this.movingAround();
                } else {
                    BlockPos blockPos2 = this.target.m_20183_();
                    if (axis == Direction.Axis.X && blockPos.m_123341_() == blockPos2.m_123341_() || axis == Direction.Axis.Z && blockPos.m_123343_() == blockPos2.m_123343_() || axis == Direction.Axis.Y && blockPos.m_123342_() == blockPos2.m_123342_()) {
                        this.movingAround();
                    }
                }
            }
        }
    }

    public boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !entity.f_19794_;
    }

    public boolean m_6060_() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 16384.0;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = this.m_19749_();
        Entity hittedEntity = entityHitResult.m_82443_();
        if (!this.m_9236_().m_5776_() && entity != null && hittedEntity != entity && !(hittedEntity instanceof TinyEyeEntity) || hittedEntity instanceof Arrow) {
            this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
            if (hittedEntity instanceof LivingEntity) {
                this.teleportEntityRandom((LivingEntity)hittedEntity);
                hittedEntity.m_6469_(this.createDamageSource((Entity)this), 3.0f);
            }
            this.m_146870_();
        }
    }

    private DamageSource createDamageSource(Entity entity) {
        return entity.m_269291_().m_269298_(EntityInit.TINY_EYE_KEY, entity);
    }

    private void teleportEntityRandom(LivingEntity livingEntity) {
        for (int counter = 0; counter < 100; ++counter) {
            float randomFloat = this.m_9236_().m_213780_().m_188501_() * ((float)Math.PI * 2);
            int posX = livingEntity.m_20183_().m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)randomFloat) * 9.0f + (float)livingEntity.m_9236_().m_213780_().m_188503_(30)));
            int posZ = livingEntity.m_20183_().m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)randomFloat) * 9.0f + (float)livingEntity.m_9236_().m_213780_().m_188503_(30)));
            int posY = livingEntity.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, posX, posZ);
            BlockPos teleportPos = new BlockPos(posX, posY, posZ);
            if (!livingEntity.m_9236_().m_46812_(teleportPos.m_123341_() - 4, teleportPos.m_123342_() - 4, teleportPos.m_123343_() - 4, teleportPos.m_123341_() + 4, teleportPos.m_123342_() + 4, teleportPos.m_123343_() + 4) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)livingEntity.m_9236_(), (BlockPos)teleportPos, (EntityType)EntityType.f_20532_)) continue;
            if (!this.m_9236_().m_5776_()) {
                livingEntity.m_20324_((double)teleportPos.m_123341_(), (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_());
            }
            livingEntity.m_9236_().m_5594_(null, teleportPos, SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
            break;
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
    }
}

